package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

//Immutable part of pod agent deployment meta
public class PodAgentConfig {
    private final Optional<SidecarVolumeSettings> sidecarVolumeSettings;

    public PodAgentConfig(Optional<SidecarVolumeSettings> sidecarVolumeSettings) {
        this.sidecarVolumeSettings = sidecarVolumeSettings;
    }

    public Optional<SidecarVolumeSettings> getSidecarVolumeSettings() { return sidecarVolumeSettings; }

    @VisibleForTesting
    public PodAgentConfig withSidecarVolumeSettings(Optional<SidecarVolumeSettings> sidecarVolumeSettings) {
        return new PodAgentConfig(sidecarVolumeSettings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodAgentConfig that = (PodAgentConfig) o;
        return Objects.equals(sidecarVolumeSettings, that.sidecarVolumeSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sidecarVolumeSettings);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("sidecarVolumeSettings", sidecarVolumeSettings)
                .toString();
    }
}
