package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils;

public class PushAgentConfig {
    public final static int LOGBROKER_PORT = 2222;
    private final static int LOGBROKER_MONITORING_PORT = LogbrokerPatcherUtils.LOGBROKER_AGENT_MONITORING_PORT;
    private final static String LOGBROKER_HOST = LogbrokerPatcherUtils.LOGBROKER_AGENT_OUT_CHANNEL_ENDPOINT;
    private final static int LOG_LEVEL = 7;
    private final static long TVM_CLIENT_ID = LogbrokerPatcherUtils.LOGBROKER_AGENT_COMMUNAL_TOPIC_DESCRIPTION.getTvmClientId();
    private final static int TVM_DST_ID = 2001059;
    private final static String TVM_SECRET = LogbrokerPatcherUtils.LOGBROKER_AGENT_TVM_SECRET_ENV_NAME;
    private final static String TOPIC_1 = "deploy/mvp-test";
    private final static String TOPIC_2 = LogbrokerPatcherUtils.LOGBROKER_AGENT_COMMUNAL_TOPIC_DESCRIPTION.getName();
    private final static int MAX_DISK_SIZE_BYTES = 1000000000;
    private final static int MAX_ROTATE_COUNT = 3;
    private final static List<Integer> SOLOMON_TVM_CLIENT_IDS = LogbrokerPatcherUtils.LOGBROKER_AGENT_SOLOMON_TVM_CLIENT_IDS;

    private final String stageId;
    private final String staticSecret;

    public PushAgentConfig(String stageId, String staticSecret) {
        this.stageId = stageId;
        this.staticSecret = staticSecret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PushAgentConfig)) return false;
        PushAgentConfig that = (PushAgentConfig) o;
        return stageId.equals(that.stageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(stageId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("stageId", stageId)
                .toString();
    }

    public String toJsonString() {
        ObjectMapper mapper = new ObjectMapper();

        ObjectNode confNode = mapper.createObjectNode();
        confNode.put("port", LOGBROKER_PORT);
        confNode.put("mon_port", LOGBROKER_MONITORING_PORT);
        confNode.put("logbroker_host", LOGBROKER_HOST);
        confNode.put("log_level", LOG_LEVEL);

        ObjectNode credentialsNode = mapper.createObjectNode();
        credentialsNode.put("tvm_client_id", TVM_CLIENT_ID);
        credentialsNode.put("tvm_dst_id", TVM_DST_ID);
        credentialsNode.put("tvm_secret", TVM_SECRET);
        credentialsNode.put("static_secret", staticSecret);

        ArrayNode solomonClientIdsNode = mapper.createArrayNode();
        SOLOMON_TVM_CLIENT_IDS.forEach(solomonClientIdsNode::add);

        credentialsNode.set("solomon_tvm_client_id", solomonClientIdsNode);
        confNode.set("credentials", credentialsNode);

        ArrayNode logsNode = mapper.createArrayNode();

        ObjectNode logNameNode = mapper.createObjectNode();
        logNameNode.put("log_name", stageId);
        logNameNode.put("topic", TOPIC_1);
        logNameNode.put("topic2", TOPIC_2);
        logNameNode.put("max_disk_size_bytes", MAX_DISK_SIZE_BYTES);
        logNameNode.put("max_rotate_count", MAX_ROTATE_COUNT);

        logsNode.add(logNameNode);
        confNode.set("logs", logsNode);

        try {
            return mapper.writeValueAsString(confNode);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}
