package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

public class ReplicaSetDeploymentStrategy extends DeploymentStrategy {
    private final int minUnavailable;
    private final int maxSurge;
    private final Optional<DeployReadyCriterion> deployReadyCriterion;

    public ReplicaSetDeploymentStrategy(int minUnavailable,
                                        int maxUnavailable,
                                        int maxSurge,
                                        int minCreatedSeconds,
                                        int maxTolerableDowntimeSeconds,
                                        int maxTolerableDowntimePods,
                                        Optional<DeploySpeed> deploySpeed,
                                        Optional<DeployReadyCriterion> deployReadyCriterion) {
        super(maxUnavailable,
                minCreatedSeconds,
                maxTolerableDowntimeSeconds,
                maxTolerableDowntimePods,
                deploySpeed);
        this.minUnavailable = minUnavailable;
        this.maxSurge = maxSurge;
        this.deployReadyCriterion = deployReadyCriterion;
    }

    public int getMinUnavailable() {
        return minUnavailable;
    }

    public int getMaxSurge() {
        return maxSurge;
    }

    public Optional<DeployReadyCriterion> getDeployReadyCriterion() {
        return deployReadyCriterion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ReplicaSetDeploymentStrategy)) return false;
        ReplicaSetDeploymentStrategy that = (ReplicaSetDeploymentStrategy) o;
        return super.equals(o) &&
                minUnavailable == that.minUnavailable &&
                maxSurge == that.maxSurge &&
                Objects.equals(deployReadyCriterion, that.deployReadyCriterion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(),
                minUnavailable,
                maxSurge,
                deployReadyCriterion);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("minUnavailable", minUnavailable)
                .add("maxUnavailable", getMaxUnavailable())
                .add("maxSurge", maxSurge)
                .add("minCreatedSeconds", getMinCreatedSeconds())
                .add("maxTolerableDowntimeSeconds", getMaxTolerableDowntimeSeconds())
                .add("maxTolerableDowntimePods", getMaxTolerableDowntimePods())
                .add("deploySpeed", getDeploySpeed())
                .add("deployReadyCriterion", getDeployReadyCriterion())
                .toString();
    }
}

