package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.TReplicaSetStatus;

public class ReplicaSetUnitStatus extends DeployUnitStatusDetails {
    public static class PerClusterStatus {
        private final String replicaSetRef;
        private final List<String> endpointSetRefs;
        private final String horizontalPodAutoscalerRef;
        private final Optional<TReplicaSetStatus> rawStatus;

        public PerClusterStatus(String replicaSetRef,
                                List<String> endpointSetRefs,
                                String horizontalPodAutoscalerRef,
                                Optional<TReplicaSetStatus> rawStatus) {
            this.replicaSetRef = replicaSetRef;
            this.endpointSetRefs = endpointSetRefs;
            this.horizontalPodAutoscalerRef = horizontalPodAutoscalerRef;
            this.rawStatus = rawStatus;
        }

        public String getReplicaSetRef() {
            return replicaSetRef;
        }

        public List<String> getEndpointSetRefs() {
            return endpointSetRefs;
        }

        public String getHorizontalPodAutoscalerRef() {
            return horizontalPodAutoscalerRef;
        }

        public Optional<TReplicaSetStatus> getRawStatus() {
            return rawStatus;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PerClusterStatus)) {
                return false;
            }
            PerClusterStatus that = (PerClusterStatus) o;
            return Objects.equals(replicaSetRef, that.replicaSetRef) &&
                    Objects.equals(endpointSetRefs, that.endpointSetRefs) &&
                    Objects.equals(horizontalPodAutoscalerRef, that.horizontalPodAutoscalerRef) &&
                    Objects.equals(rawStatus, that.rawStatus);
        }

        @Override
        public int hashCode() {
            return Objects.hash(replicaSetRef, endpointSetRefs, horizontalPodAutoscalerRef, rawStatus);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this)
                    .add("replicaSetRef", replicaSetRef)
                    .add("endpointSetRefs", endpointSetRefs)
                    .add("horizontalPodAutoscalerRef", horizontalPodAutoscalerRef)
                    .add("rawStatus", rawStatus)
                    .toString();
        }
    }

    private final Map<String, PerClusterStatus> clusterStatuses;

    public ReplicaSetUnitStatus(Map<String, PerClusterStatus> clusterStatuses) {
        this.clusterStatuses = clusterStatuses;
    }

    public Map<String, PerClusterStatus> getClusterStatuses() {
        return clusterStatuses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicaSetUnitStatus)) {
            return false;
        }
        ReplicaSetUnitStatus that = (ReplicaSetUnitStatus) o;
        return Objects.equals(clusterStatuses, that.clusterStatuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clusterStatuses);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("perClusterStatus", clusterStatuses)
                .toString();
    }
}
