package ru.yandex.infra.stage.dto;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.google.common.base.MoreObjects;

public class RuntimeDeployControls {

    private final Map<String, Set<String>> approvedClusterList;
    private final Map<String, DeployUnitOverrides> deployUnitOverrides;
    private final Map<String, DeployUnitSpec.DeploySettings> deploySettings;

    public RuntimeDeployControls(Map<String, Set<String>> approvedClusterList,
                                 Map<String, DeployUnitOverrides> deployUnitOverrides,
                                 Map<String, DeployUnitSpec.DeploySettings> deploySettings) {
        this.approvedClusterList = approvedClusterList;
        this.deployUnitOverrides = deployUnitOverrides;
        this.deploySettings = deploySettings;
    }

    public Map<String, Set<String>> getApprovedClusterList() {
        return approvedClusterList;
    }


    public Map<String, DeployUnitOverrides> getDeployUnitOverrides() {
        return deployUnitOverrides;
    }


    public Map<String, DeployUnitSpec.DeploySettings> getDeploySettings() {
        return deploySettings;
    }

    public boolean equals(RuntimeDeployControls that, String deployUnit) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        return (approvedClusterList == that.approvedClusterList ||
                Objects.equals(approvedClusterList.get(deployUnit), that.approvedClusterList.get(deployUnit))) &&
               (deployUnitOverrides == that.deployUnitOverrides ||
                Objects.equals(deployUnitOverrides.get(deployUnit), that.deployUnitOverrides.get(deployUnit))) &&
               (deploySettings == that.deploySettings ||
                Objects.equals(deploySettings.get(deployUnit), that.deploySettings.get(deployUnit)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RuntimeDeployControls that = (RuntimeDeployControls) o;
        return Objects.equals(approvedClusterList, that.approvedClusterList)
                && Objects.equals(deploySettings, that.deploySettings)
                && Objects.equals(deployUnitOverrides, that.deployUnitOverrides);
    }

    @Override
    public int hashCode() {
        return Objects.hash(approvedClusterList, deployUnitOverrides);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("approvedClusterList", approvedClusterList)
                .add("deployUnitOverrides", deployUnitOverrides)
                .add("deploySettings", deploySettings)
                .toString();
    }

}
