package ru.yandex.infra.stage.dto;

import java.util.Map;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class SandboxResourceInfo {
    private final long revision;
    private final Map<String, String> override;


    public SandboxResourceInfo(long revision, Map<String, String> override) {
        this.revision = revision;
        this.override = override;
    }

    public long getRevision() {
        return revision;
    }

    public Map<String, String> getOverride() {
        return override;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SandboxResourceInfo that = (SandboxResourceInfo) o;
        return revision == that.revision &&
                Objects.equal(override, that.override);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(revision, override);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("revision", revision)
                .add("override", override)
                .toString();
    }
}
