package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class Secret {
    private final SecretRef secretRef;
    private final String delegationToken;

    public Secret(SecretRef secretRef, String delegationToken) {
        this.secretRef = secretRef;
        this.delegationToken = delegationToken;
    }

    public SecretRef getSecretRef() {
        return secretRef;
    }

    public String getDelegationToken() {
        return delegationToken;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("secretRef", secretRef)
                .add("delegationToken", delegationToken)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Secret)) {
            return false;
        }
        Secret secret = (Secret) o;
        return Objects.equals(secretRef, secret.secretRef) &&
                Objects.equals(delegationToken, secret.delegationToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(secretRef, delegationToken);
    }
}
