package ru.yandex.infra.stage.dto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class SecretRef {

    private final String uuid;
    private final String version;

    public SecretRef(String uuid, String version) {
        this.uuid = uuid;
        this.version = version;
    }

    public String getUuid() {
        return uuid;
    }

    public String getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecretRef secretRef = (SecretRef) o;
        return Objects.equal(uuid, secretRef.uuid) &&
                Objects.equal(version, secretRef.version);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(uuid, version);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("uuid", uuid)
                .add("version", version)
                .toString();
    }
}
