package ru.yandex.infra.stage.dto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class SecretSelector {

    private final String alias;
    private final String key;

    public SecretSelector(String alias, String key) {
        this.alias = alias;
        this.key = key;
    }

    public String getAlias() {
        return alias;
    }

    public String getKey() {
        return key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecretSelector that = (SecretSelector) o;
        return Objects.equal(alias, that.alias) && Objects.equal(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(alias, key);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("alias", alias)
                .add("key", key)
                .toString();
    }
}
