package ru.yandex.infra.stage.dto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public final class SecuritySettings {
    private final boolean disableDefaultlyEnabledChildOnlyIsolation;
    private final boolean disableDefaultlyEnabledSecretEnv;

    public SecuritySettings(boolean disableDefaultlyEnableChildOnlyIsolation, boolean disableDefaultlyEnabledSecretEnv) {
        this.disableDefaultlyEnabledChildOnlyIsolation = disableDefaultlyEnableChildOnlyIsolation;
        this.disableDefaultlyEnabledSecretEnv = disableDefaultlyEnabledSecretEnv;
    }

    public boolean disableDefaultlyEnabledChildOnlyIsolation() {
        return disableDefaultlyEnabledChildOnlyIsolation;
    }

    public boolean disableDefaultlyEnabledSecretEnv() {
        return disableDefaultlyEnabledSecretEnv;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {

        private boolean disableDefaultlyEnabledChildOnlyIsolation;
        private boolean disableDefaultlyEnabledSecretEnv;

        private Builder(SecuritySettings securitySettings) {
            this.disableDefaultlyEnabledChildOnlyIsolation = securitySettings.disableDefaultlyEnabledChildOnlyIsolation;
            this.disableDefaultlyEnabledSecretEnv = securitySettings.disableDefaultlyEnabledSecretEnv;
        }

        public Builder withDisableDefaultlyEnabledChildOnlyIsolation(boolean disableDefaultlyEnabledChildOnlyIsolation) {
            this.disableDefaultlyEnabledChildOnlyIsolation = disableDefaultlyEnabledChildOnlyIsolation;
            return this;
        }

        public Builder withDisableDefaultlyEnabledSecretEnv(boolean disableDefaultlyEnabledSecretEnv) {
            this.disableDefaultlyEnabledSecretEnv = disableDefaultlyEnabledSecretEnv;
            return this;
        }

        public SecuritySettings build() {
            return new SecuritySettings(disableDefaultlyEnabledChildOnlyIsolation, disableDefaultlyEnabledSecretEnv);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecuritySettings that = (SecuritySettings) o;
        return disableDefaultlyEnabledChildOnlyIsolation == that.disableDefaultlyEnabledChildOnlyIsolation &&
                disableDefaultlyEnabledSecretEnv == that.disableDefaultlyEnabledSecretEnv;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(disableDefaultlyEnabledChildOnlyIsolation, disableDefaultlyEnabledSecretEnv);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("disableDefaultlyEnabledChildOnlyIsolation", disableDefaultlyEnabledChildOnlyIsolation)
                .add("disableDefaultlyEnabledSecretEnv", disableDefaultlyEnabledSecretEnv)
                .toString();
    }
}
