package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class SidecarVolumeSettings {
    private final StorageClass storageClass;

    public SidecarVolumeSettings(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public StorageClass getStorageClass() { return storageClass; }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SidecarVolumeSettings that = (SidecarVolumeSettings) o;
        return storageClass == that.storageClass;
    }

    @Override
    public int hashCode() {
        return Objects.hash(storageClass);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("storageClass", storageClass)
                .toString();
    }

    public enum StorageClass {
        UNRECOGNIZED,
        AUTO,
        HDD,
        SSD
    }
}
