package ru.yandex.infra.stage.dto;

import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

public class StageSpec {
    private final Map<String, DeployUnitSpec> deployUnits;
    private final Map<String, DynamicResourceSpec> dynamicResources;
    private final String accountId;
    private final int revision;
    private final boolean isSoxService;
    private final SortedMap<String, String> envVars;

    public StageSpec(Map<String, DeployUnitSpec> deployUnits, String accountId,
                     int revision,
                     boolean isSoxService,
                     Map<String, DynamicResourceSpec> dynamicResources,
                     Map<String, String> envVars) {
        this.deployUnits = deployUnits;
        this.dynamicResources = dynamicResources;
        this.accountId = accountId;
        this.revision = revision;
        this.isSoxService = isSoxService;
        this.envVars = new TreeMap<>(envVars);
    }

    public Map<String, DeployUnitSpec> getDeployUnits() {
        return deployUnits;
    }

    public String getAccountId() {
        return accountId;
    }

    public int getRevision() {
        return revision;
    }

    public boolean isSoxService() {
        return isSoxService;
    }

    public Map<String, DynamicResourceSpec> getDynamicResources() {
        return dynamicResources;
    }

    public SortedMap<String, String> getEnvVars() { return envVars; }

    @VisibleForTesting
    public StageSpec withDeployUnits(Map<String, DeployUnitSpec> deployUnits) {
        return new StageSpec(deployUnits, accountId, revision, isSoxService, dynamicResources, envVars);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StageSpec stageSpec = (StageSpec) o;
        return revision == stageSpec.revision &&
                isSoxService == stageSpec.isSoxService &&
                Objects.equals(deployUnits, stageSpec.deployUnits) &&
                Objects.equals(dynamicResources, stageSpec.dynamicResources) &&
                Objects.equals(accountId, stageSpec.accountId) &&
                ((StageSpec) o).isSoxService == isSoxService &&
                Objects.equals(envVars, stageSpec.envVars);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployUnits, dynamicResources, accountId, revision,
                isSoxService, envVars);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("deployUnits", deployUnits)
                .add("dynamicResources", dynamicResources)
                .add("accountId", accountId)
                .add("revision", revision)
                .add("isSoxService", isSoxService)
                .add("envVars", envVars)
                .toString();
    }
}
