package ru.yandex.infra.stage.dto;

import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;

public class StageStatus {
    private final Map<String, DeployUnitStatus> deployUnits;
    private final Map<String, DynamicResourceStatus> dynamicResources;
    private final int revision;
    private final Condition validated;
    private final long specTimestamp;

    public StageStatus(Map<String, DeployUnitStatus> deployUnits,
                       Map<String, DynamicResourceStatus> dynamicResources,
                       int revision, Condition validated, long specTimestamp) {
        this.deployUnits = deployUnits;
        this.revision = revision;
        this.validated = validated;
        this.specTimestamp = specTimestamp;
        this.dynamicResources = dynamicResources;
    }

    public Map<String, DeployUnitStatus> getDeployUnits() {
        return deployUnits;
    }

    public Map<String, DynamicResourceStatus> getDynamicResources() {
        return dynamicResources;
    }

    public int getRevision() {
        return revision;
    }

    public Condition getValidated() {
        return validated;
    }

    public long getSpecTimestamp() {
        return specTimestamp;
    }

    public StageStatus withRevision(int revision) {
        return new StageStatus(deployUnits, dynamicResources, revision, validated, specTimestamp);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StageStatus that = (StageStatus) o;
        return revision == that.revision &&
                specTimestamp == that.specTimestamp &&
                Objects.equals(deployUnits, that.deployUnits) &&
                Objects.equals(dynamicResources, that.dynamicResources) &&
                Objects.equals(validated, that.validated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployUnits, dynamicResources, revision, validated, specTimestamp);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("deployUnits", deployUnits)
                .add("dynamicResources", dynamicResources)
                .add("revision", revision)
                .add("validated", validated)
                .add("specTimestamp", specTimestamp)
                .toString();
    }
}
