package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class TvmApp {
    private final int appId;
    private final String alias;

    public TvmApp(int appId, String alias) {
        this.appId = appId;
        this.alias = alias;
    }

    public int getAppId() {
        return appId;
    }

    public String getAlias() {
        return alias;
    }

    public String getAliasOrAppId() {
        if (!alias.isEmpty()) {
            return alias;
        }
        return Integer.toString(appId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TvmApp)) return false;
        TvmApp that = (TvmApp) o;
        return appId == that.appId && Objects.equals(alias, that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, alias);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("appId", appId)
                .add("alias", alias)
                .toString();
    }
}
