package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Objects;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;

public class TvmClient {
    public static final String TVM_CLIENT_SECRET_ENV_PREFIX = "TVM_CLIENT_SECRET";

    private final SecretSelector secretSelector;
    private final TvmApp source;
    private final List<TvmApp> destinations;
    private final String rolesForIdmSlug;

    public TvmClient(SecretSelector secretSelector, TvmApp source, List<TvmApp> destinations, String rolesForIdmSlug) {
        this.secretSelector = secretSelector;
        this.source = source;
        this.destinations = destinations;
        this.rolesForIdmSlug = rolesForIdmSlug;
    }

    public String getTvmClientSecretEnvName() {
        return String.format("%s_%s", TVM_CLIENT_SECRET_ENV_PREFIX, source.getAppId());
    }

    public SecretSelector getSecretSelector() {
        return secretSelector;
    }

    public TvmApp getSource() {
        return source;
    }

    public List<TvmApp> getDestinations() {
        return destinations;
    }

    public String getRolesForIdmSlug() {
        return rolesForIdmSlug;
    }

    @VisibleForTesting
    public TvmClient withNoDestinations() {
        return new TvmClient(secretSelector, source, ImmutableList.of(), "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TvmClient)) return false;
        TvmClient that = (TvmClient) o;
        return Objects.equals(secretSelector, that.secretSelector) &&
            Objects.equals(source, that.source) &&
            Objects.equals(destinations, that.destinations) &&
            Objects.equals(rolesForIdmSlug, that.rolesForIdmSlug);
    }

    @Override
    public int hashCode() {
        return Objects.hash(secretSelector, source, destinations, rolesForIdmSlug);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("secretSelector", secretSelector)
                .add("source", source)
                .add("destinations", destinations)
                .add("roles_for_idm_slug", rolesForIdmSlug)
                .toString();
    }
}
