package ru.yandex.infra.stage.inject;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.yp.model.YpObjectType;

public final class GCSettings {
    private final GCLimit defaultLimit;
    private final ImmutableMap<YpObjectType, GCLimit> customLimit;

    public GCSettings(GCLimit defaultLimit, Map<YpObjectType, GCLimit> customLimit) {
        this.defaultLimit = defaultLimit;
        this.customLimit = ImmutableMap.copyOf(customLimit);
    }

    public GCLimit getGCLimit(YpObjectType type) {
        return customLimit.getOrDefault(type, defaultLimit);
    }
}
