package ru.yandex.infra.stage.podspecs;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.revision.RevisionsHolder;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;

public class EndpointSetSpecCompositePatcher implements SpecPatcher<DataModel.TEndpointSetSpec.Builder> {

    public static final String DEPLOY_LABEL_KEY = "deploy";
    private final RevisionsHolder<DataModel.TEndpointSetSpec.Builder> revisionsHolder;

    public EndpointSetSpecCompositePatcher(RevisionsHolder<DataModel.TEndpointSetSpec.Builder> revisionsHolder) {
        this.revisionsHolder = revisionsHolder;
    }

    @Override
    public void patch(DataModel.TEndpointSetSpec.Builder builder,
                      DeployUnitContext context,
                      YTreeBuilder labelsBuilder) {
        int revisionId = context.getPatchersRevision();

        var patchers = revisionsHolder.getPatchersFor(revisionId)
                .orElseThrow(() -> new IllegalArgumentException(
                        String.format("Project id %s; stage id %s; deploy unit id %s: unknown patchers revision %d",
                                context.getStageContext().getProjectId(),
                                context.getStageContext().getStageId(),
                                context.getDeployUnitId(),
                                revisionId)
                ));

        patchers.forEach(value -> {
            value.patch(builder, context, labelsBuilder);
        });
    }
}
