package ru.yandex.infra.stage.podspecs;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.infra.stage.dto.DownloadableResource;

public class FixedResourceSupplier implements ResourceSupplier {
    private final ResourceWithMeta resource;
    private final SandboxReleaseGetter releaseGetter;

    public FixedResourceSupplier(DownloadableResource resource, Optional<SandboxResourceMeta> meta,
                                 SandboxReleaseGetter sandboxReleaseGetter) {
        this.resource = new ResourceWithMeta(resource, meta);
        this.releaseGetter = sandboxReleaseGetter;
    }

    public static FixedResourceSupplier withoutMeta(DownloadableResource resource) {
        return new FixedResourceSupplier(resource, Optional.empty(), null);
    }

    public static FixedResourceSupplier withMeta(DownloadableResource resource, SandboxResourceMeta meta) {
        return new FixedResourceSupplier(resource, Optional.of(meta), null);
    }

    public static FixedResourceSupplier withSupplierAndMeta(DownloadableResource resource, SandboxResourceMeta meta, SandboxReleaseGetter sandboxReleaseGetter) {
        return new FixedResourceSupplier(resource, Optional.of(meta), sandboxReleaseGetter);
    }

    @Override
    public ResourceWithMeta get() {
        return resource;
    }

    @Override
    public CompletableFuture<?> start() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Duration timeSinceLastUpdate() {
        return Duration.ZERO;
    }

    @Override
    public SandboxReleaseGetter getSandboxReleaseGetter() {
        if (releaseGetter == null) {
            throw new IllegalArgumentException("Sandbox release getter not provided");
        }
        return releaseGetter;
    }
}
