package ru.yandex.infra.stage.podspecs;

import com.google.protobuf.ByteString;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.revision.RevisionsHolder;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.TPodTemplateSpec;
import ru.yandex.yt.ytree.TAttribute;

public class PodSpecCompositePatcher implements SpecPatcher<TPodTemplateSpec.Builder> {

    public static final String DEPLOY_LABEL_KEY = "deploy";

    private final RevisionsHolder<TPodTemplateSpec.Builder> revisionsHolder;

    public PodSpecCompositePatcher(RevisionsHolder<TPodTemplateSpec.Builder> revisionsHolder) {
        this.revisionsHolder = revisionsHolder;
    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder yTreeBuilder) {
        int revisionId = context.getPatchersRevision();

        var patchers = revisionsHolder.getPatchersFor(revisionId)
                .orElseThrow(() -> new IllegalArgumentException(
                        String.format("Project id %s; stage id %s; deploy unit id %s: unknown patchers revision %d",
                                context.getStageContext().getProjectId(),
                                context.getStageContext().getStageId(),
                                context.getDeployUnitId(),
                                revisionId)
                ));

        YTreeBuilder labelsBuilder = new YTreeBuilder().beginMap();

        patchers.forEach(value -> value.patch(podTemplateSpecBuilder, context, labelsBuilder));

        podTemplateSpecBuilder.getLabelsBuilder().addAttributes(TAttribute.newBuilder()
                .setKey(DEPLOY_LABEL_KEY)
                .setValue(ByteString.copyFrom(labelsBuilder.endMap().build().toBinary())));
    }
}
