package ru.yandex.infra.stage.podspecs;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.dto.DownloadableResource;

public class ResourceWithMeta {
    private final DownloadableResource resource;
    private final Optional<SandboxResourceMeta> meta;

    public ResourceWithMeta(DownloadableResource resource, Optional<SandboxResourceMeta> meta) {
        this.resource = resource;
        this.meta = meta;
    }

    public DownloadableResource getResource() {
        return resource;
    }

    public Optional<SandboxResourceMeta> getMeta() {
        return meta;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ResourceWithMeta)) return false;
        ResourceWithMeta that = (ResourceWithMeta) o;
        return Objects.equals(resource, that.resource) &&
                Objects.equals(meta, that.meta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource, meta);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("resource", resource)
                .add("meta", meta)
                .toString();
    }
}
