package ru.yandex.infra.stage.podspecs;

import java.util.concurrent.CompletableFuture;

// Encapsulates sandbox interaction specifics.
public interface SandboxReleaseGetter {
    CompletableFuture<ResourceWithMeta> getLatestRelease(String resourceType, boolean useChecksum);
    CompletableFuture<Void> validateSandboxResource(long resourceId, String resourceUrl);
    CompletableFuture<ResourceWithMeta> getReleaseByResourceId(long resourceId, boolean useChecksum);
}
