package ru.yandex.infra.stage.podspecs;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;

public class SandboxResourceMeta {
    private final long taskId;
    private final long resourceId;
    private final Map<String, String> attributes;

    public SandboxResourceMeta(long taskId, long resourceId, Map<String, String> attributes) {
        this.taskId = taskId;
        this.resourceId = resourceId;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public long getTaskId() {
        return taskId;
    }

    public long getResourceId() {
        return resourceId;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SandboxResourceMeta)) return false;
        SandboxResourceMeta that = (SandboxResourceMeta) o;
        return taskId == that.taskId &&
                resourceId == that.resourceId &&
                attributes.equals(that.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taskId, resourceId, attributes);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("taskId", taskId)
                .add("resourceId", resourceId)
                .add("attributes", attributes)
                .toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {

        private final long taskId;
        private final long resourceId;
        private Map<String, String> attributes;

        Builder(SandboxResourceMeta sandboxResourceMeta) {
            this.taskId = sandboxResourceMeta.getTaskId();
            this.resourceId = sandboxResourceMeta.getResourceId();
            this.attributes = new HashMap<>(sandboxResourceMeta.getAttributes());
        }

        public Builder withAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public SandboxResourceMeta build() {
            return new SandboxResourceMeta(
                    taskId,
                    resourceId,
                    attributes
            );
        }
    }
}
