package ru.yandex.infra.stage.podspecs;

import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;

public final class SandboxResourceMetaAttributesUtils {

    private SandboxResourceMetaAttributesUtils() {

    }

    @VisibleForTesting
    static final String TRUE_ATTRIBUTE_VALUE = "True";

    @FunctionalInterface
    public interface FlagCalculator {
        boolean getFlagValue(Optional<SandboxResourceMeta> sandboxMetaOptional, String flagName);
    }

    public static final FlagCalculator FLAG_CALCULATOR = (sandboxMetaOptional, flagName) ->
            sandboxMetaOptional.map(sandboxMeta -> {
                var flagStringValue = sandboxMeta.getAttributes().get(flagName);

                return Optional.ofNullable(flagStringValue)
                        .map(TRUE_ATTRIBUTE_VALUE::equals)
                        .orElse(false);
            }).orElse(false);
}
