package ru.yandex.infra.stage.podspecs;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public final class SidecarDiskVolumeDescription
{
    public static final String HDD_STORAGE_CLASS = "hdd";
    public static final String SSD_STORAGE_CLASS = "ssd";

    private final String id;
    private final String storageClass;

    SidecarDiskVolumeDescription(String id, String storageClass) {
        this.id = id;
        this.storageClass = storageClass;
    }

    String getId() {
        return id;
    }

    String getStorageClass() {
        return storageClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SidecarDiskVolumeDescription that = (SidecarDiskVolumeDescription) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(storageClass, that.storageClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, storageClass);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("storageClass", storageClass)
                .toString();
    }
}
