package ru.yandex.infra.stage.podspecs.patcher;

import java.util.HashMap;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.infra.stage.podspecs.patcher.endpoint_set_liveness.EndpointSetLivenessPatcherV1;
import ru.yandex.infra.stage.podspecs.patcher.endpoint_set_liveness.EndpointSetLivenessPatcherV2;
import ru.yandex.infra.stage.podspecs.patcher.endpoint_set_port.EndpointSetPortPatcherV1;
import ru.yandex.yp.client.api.DataModel;

public final class EndpointSetSpecPatchersHolderFactory {

    public static PatchersHolder<DataModel.TEndpointSetSpec.Builder> fromContexts() {
        return new EndpointSetSpecPatchersHolderFactory().create();
    }

    private final Map<Class<? extends SpecPatcher<DataModel.TEndpointSetSpec.Builder>>,
            SpecPatcher<DataModel.TEndpointSetSpec.Builder>> classToPatcher;

    private EndpointSetSpecPatchersHolderFactory() {
        this.classToPatcher = new HashMap<>();
    }


    public PatchersHolder<DataModel.TEndpointSetSpec.Builder> create() {
        initializePatchers();

        return new PatchersHolder<>(ImmutableMap.copyOf(classToPatcher));
    }

    private void addPatcher(SpecPatcher<DataModel.TEndpointSetSpec.Builder> patcher) {
        Class<? extends SpecPatcher<DataModel.TEndpointSetSpec.Builder>> patcherClass =
                (Class<? extends SpecPatcher<DataModel.TEndpointSetSpec.Builder>>) patcher.getClass();

        if (null != classToPatcher.get(patcherClass)) {
            throw new RuntimeException(
                    String.format(
                            "Patcher with class %s tried to instantiate twice",
                            patcherClass.getCanonicalName()
                    )
            );
        }

        classToPatcher.put(patcherClass, patcher);
    }

    private void initializePatchers() {
        initializeEndpointSetLivenessPatcher();
        initializeEndpointSetPortPatcher();
    }

    private void initializeEndpointSetLivenessPatcher() {
        addPatcher(new EndpointSetLivenessPatcherV1());
        addPatcher(new EndpointSetLivenessPatcherV2());
    }

    private void initializeEndpointSetPortPatcher() {
        addPatcher(new EndpointSetPortPatcherV1());
    }
}
