package ru.yandex.infra.stage.podspecs.patcher;

import ru.yandex.infra.stage.podspecs.patcher.common_env.CommonEnvPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.coredump.CoredumpPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.default_anon_limit.AnonLimitPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.defaults.DefaultsPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.docker.DockerPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.dynamic_resource.DynamicResourcePatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.juggler.JugglerPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.logrotate.LogrotatePatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.monitoring.MonitoringPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.portoworkload.PortoWorkloadPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.sandbox.SandboxPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.security.SecurityPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.thread_limits.ThreadLimitsPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.thread_limits.pod_agent.PodAgentThreadLimitPatcherContexts;
import ru.yandex.infra.stage.podspecs.patcher.tvm.TvmPatcherContexts;

public interface PatcherContexts {

    static PatcherContexts with(
            CommonEnvPatcherContexts commonEnvPatcherContexts,
            CoredumpPatcherContexts coredumpPatcherContexts,
            DefaultsPatcherContexts defaultsPatcherContexts,
            DockerPatcherContexts dockerPatcherContexts,
            DynamicResourcePatcherContexts dynamicResourcePatcherContexts,
            JugglerPatcherContexts jugglerPatcherContexts,
            LogbrokerPatcherContexts logbrokerPatcherContexts,
            LogrotatePatcherContexts logrotatePatcherContexts,
            MonitoringPatcherContexts monitoringPatcherContexts,
            SandboxPatcherContexts sandboxPatcherContexts,
            ThreadLimitsPatcherContexts threadLimitsPatcherContexts,
            TvmPatcherContexts tvmPatcherContexts,
            PortoWorkloadPatcherContexts portoWorkloadPatcherContexts,
            SecurityPatcherContexts securityPatcherContexts,
            AnonLimitPatcherContexts anonLimitPatcherContexts,
            PodAgentThreadLimitPatcherContexts podAgentThreadLimitPatcherContexts
    ) {
        return new PatcherContexts() {
            @Override
            public CommonEnvPatcherContexts getCommonEnvPatcherContexts() {
                return commonEnvPatcherContexts;
            }

            @Override
            public CoredumpPatcherContexts getCoredumpPatcherContexts() {
                return coredumpPatcherContexts;
            }

            @Override
            public DefaultsPatcherContexts getDefaultsPatcherContexts() {
                return defaultsPatcherContexts;
            }

            @Override
            public DockerPatcherContexts getDockerPatcherContexts() {
                return dockerPatcherContexts;
            }

            @Override
            public DynamicResourcePatcherContexts getDynamicResourcePatcherContexts() {
                return dynamicResourcePatcherContexts;
            }

            @Override
            public JugglerPatcherContexts getJugglerPatcherContexts() {
                return jugglerPatcherContexts;
            }

            @Override
            public LogbrokerPatcherContexts getLogbrokerPatcherContexts() {
                return logbrokerPatcherContexts;
            }

            @Override
            public LogrotatePatcherContexts getLogrotatePatcherContexts() {
                return logrotatePatcherContexts;
            }

            @Override
            public MonitoringPatcherContexts getMonitoringPatcherContexts() {
                return monitoringPatcherContexts;
            }

            @Override
            public SandboxPatcherContexts getSandboxPatcherContexts() {
                return sandboxPatcherContexts;
            }

            @Override
            public ThreadLimitsPatcherContexts getThreadLimitsPatcherContexts() {
                return threadLimitsPatcherContexts;
            }

            @Override
            public TvmPatcherContexts getTvmPatcherContexts() {
                return tvmPatcherContexts;
            }

            @Override
            public PortoWorkloadPatcherContexts getPortoWorkloadPatcherContexts() {
                return portoWorkloadPatcherContexts;
            }

            @Override
            public SecurityPatcherContexts getSecurityPatcherContexts() { return securityPatcherContexts; }

            @Override
            public AnonLimitPatcherContexts getAnonLimitPatcherContexts() {
                return anonLimitPatcherContexts;
            }

            @Override
            public PodAgentThreadLimitPatcherContexts getPodAgentThreadLimitPatcherContexts() {
                return podAgentThreadLimitPatcherContexts;
            }
        };
    }

    CommonEnvPatcherContexts getCommonEnvPatcherContexts();

    CoredumpPatcherContexts getCoredumpPatcherContexts();

    DefaultsPatcherContexts getDefaultsPatcherContexts();

    DockerPatcherContexts getDockerPatcherContexts();

    DynamicResourcePatcherContexts getDynamicResourcePatcherContexts();

    JugglerPatcherContexts getJugglerPatcherContexts();

    LogbrokerPatcherContexts getLogbrokerPatcherContexts();

    LogrotatePatcherContexts getLogrotatePatcherContexts();

    MonitoringPatcherContexts getMonitoringPatcherContexts();

    SandboxPatcherContexts getSandboxPatcherContexts();

    ThreadLimitsPatcherContexts getThreadLimitsPatcherContexts();

    TvmPatcherContexts getTvmPatcherContexts();

    PortoWorkloadPatcherContexts getPortoWorkloadPatcherContexts();

    SecurityPatcherContexts getSecurityPatcherContexts();

    AnonLimitPatcherContexts getAnonLimitPatcherContexts();

    PodAgentThreadLimitPatcherContexts getPodAgentThreadLimitPatcherContexts();
}
