package ru.yandex.infra.stage.podspecs.patcher;

import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface PatcherParameters {

    static PatcherParameters with(
            Optional<String> podAgentAllocationId,
            Optional<String> logbrokerAllocationId,
            Optional<String> tvmAllocationId,
            Optional<List<String>> allSidecarDiskAllocationIds,
            long releaseGetterTimeoutSeconds,
            Map<String, Integer> blackboxEnvironments
    ) {
        return new PatcherParameters() {
            @Override
            public Optional<String> getPodAgentAllocationId() {
                return podAgentAllocationId;
            }

            @Override
            public Optional<String> getLogbrokerAllocationId() {
                return logbrokerAllocationId;
            }

            @Override
            public Optional<String> getTvmAllocationId() {
                return tvmAllocationId;
            }

            @Override
            public Optional<List<String>> getAllSidecarDiskAllocationIds() {
                return allSidecarDiskAllocationIds;
            }

            @Override
            public long getReleaseGetterTimeoutSeconds() {
                return releaseGetterTimeoutSeconds;
            }

            @Override
            public Map<String, Integer> getBlackboxEnvironments() {
                return blackboxEnvironments;
            }
        };
    }

    Optional<String> getPodAgentAllocationId();

    Optional<String> getLogbrokerAllocationId();

    Optional<String> getTvmAllocationId();

    Optional<List<String>> getAllSidecarDiskAllocationIds();

    long getReleaseGetterTimeoutSeconds();

    Map<String, Integer> getBlackboxEnvironments();
}
