package ru.yandex.infra.stage.podspecs.patcher;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

import com.google.protobuf.Message;

import ru.yandex.infra.stage.podspecs.SpecPatcher;

public class PatchersHolder<T extends Message.Builder> {

    private final Map<Class<? extends SpecPatcher<T>>, ? extends SpecPatcher<T>> classToPatcher;

    public PatchersHolder(Map<Class<? extends SpecPatcher<T>>, ? extends SpecPatcher<T>> classToPatcher) {
        this.classToPatcher = classToPatcher;
    }

    private Optional<SpecPatcher<T>> getPatcherOptional(Class<? extends SpecPatcher<T>> patcherClass) {
        return Optional.ofNullable(classToPatcher.get(patcherClass));
    }

    private SpecPatcher<T> getPatcher(Class<? extends SpecPatcher<T>> patcherClass) {
        return getPatcherOptional(patcherClass)
                .orElseThrow(() ->
                        new NoSuchElementException(
                                String.format("Patcher with class %s not found",
                                        patcherClass.getCanonicalName()
                                )
                        )
                );
    }

    public List<SpecPatcher<T>> getPatchersInExactOrder(List<Class<? extends SpecPatcher<T>>> patcherClasses) {
        return patcherClasses.stream()
                .map(this::getPatcher)
                .collect(Collectors.toUnmodifiableList());
    }
}
