package ru.yandex.infra.stage.podspecs.patcher;

import com.typesafe.config.Config;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;
import ru.yandex.infra.stage.podspecs.ResourceSupplierFactory;

public interface ResourceSupplierFactoryHolder {

    static ResourceSupplierFactoryHolder with(ResourceSupplierFactory factory) {
        return new ResourceSupplierFactoryHolder() {
            @Override
            public ResourceSupplierFactory getResourceSupplierFactory() {
                return factory;
            }

            @Override
            public ResourceSupplier createIfAbsent(Config config, String resourceName, boolean useChecksum) {
                return factory.createIfAbsent(config, resourceName, useChecksum);
            }
        };
    }

    ResourceSupplierFactory getResourceSupplierFactory();

    ResourceSupplier createIfAbsent(Config config, String resourceName, boolean useChecksum);
}
