package ru.yandex.infra.stage.podspecs.patcher;

import ru.yandex.lang.NonNullApi;

import static ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils.LOGBROKER_BOX_ID;
import static ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils.LOGBROKER_BOX_ID_UNDERSCORED;
import static ru.yandex.infra.stage.podspecs.patcher.tvm.TvmPatcherUtils.TVM_BOX_ID;
import static ru.yandex.infra.stage.podspecs.patcher.tvm.TvmPatcherUtils.TVM_BOX_ID_UNDERSCORED;

@NonNullApi
public enum SystemBoxId {
    TVM_BOX(TVM_BOX_ID),
    TVM_BOX_UNDERSCORED(TVM_BOX_ID_UNDERSCORED),
    LOGBROKER_BOX(LOGBROKER_BOX_ID),
    LOGBROKER_BOX_UNDERSCORED(LOGBROKER_BOX_ID_UNDERSCORED);

    private final String value;

    SystemBoxId(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}
