package ru.yandex.infra.stage.podspecs.patcher.common_env;

import java.util.function.Function;

import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.pods.TComputeResources;

public enum ResourceRequestParameter {

    VCPU_GUARANTEE(DataModel.TPodSpec.TResourceRequests.Builder::getVcpuGuarantee, TComputeResources.Builder::getVcpuGuarantee),
    VCPU_LIMIT(DataModel.TPodSpec.TResourceRequests.Builder::getVcpuLimit, TComputeResources.Builder::getVcpuLimit),
    MEMORY_GUARANTEE(DataModel.TPodSpec.TResourceRequests.Builder::getMemoryGuarantee, TComputeResources.Builder::getMemoryGuarantee),
    MEMORY_LIMIT(DataModel.TPodSpec.TResourceRequests.Builder::getMemoryLimit, TComputeResources.Builder::getMemoryLimit),
    ANONYMOUS_MEMORY_LIMIT(DataModel.TPodSpec.TResourceRequests.Builder::getAnonymousMemoryLimit, TComputeResources.Builder::getAnonymousMemoryLimit),
    THREAD_LIMIT(DataModel.TPodSpec.TResourceRequests.Builder::getThreadLimit, TComputeResources.Builder::getThreadLimit);

    public final Function<DataModel.TPodSpec.TResourceRequests.Builder, Long> getResourceRequestValue;
    public final Function<TComputeResources.Builder, Long> getComputeResourceValue;

    ResourceRequestParameter(Function<DataModel.TPodSpec.TResourceRequests.Builder, Long> getResourceRequestValue,
                             Function<TComputeResources.Builder, Long> getComputeResourceValue) {
        this.getResourceRequestValue = getResourceRequestValue;
        this.getComputeResourceValue = getComputeResourceValue;
    }

    public String getEnvVarName() {
        return CommonEnvPatcherUtils.DEPLOY_VARS_PREFIX + "_" + name();
    }
}
