package ru.yandex.infra.stage.podspecs.patcher.default_anon_limit;

import ru.yandex.yp.client.api.DataModel;

public class AnonLimitPatcherV1 extends AnonLimitPatcherV1Base {

    public AnonLimitPatcherV1(AnonLimitPatcherContext context) {
        super(context);
    }

    @Override
    protected void patchMissedAnonMemoryLimit(DataModel.TPodSpec.TResourceRequests.Builder resources) {
        //Total memory limit is too small to reserve space for caches...
        if (resources.getMemoryLimit() < DEFAULT_FILE_CACHE_RESERVED_MEMORY_SIZE) {
            return;
        }

        resources.setAnonymousMemoryLimit(resources.getMemoryLimit() - DEFAULT_FILE_CACHE_RESERVED_MEMORY_SIZE);
    }
}

