package ru.yandex.infra.stage.podspecs.patcher.default_anon_limit;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.PodSpecUtils;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TPodTemplateSpec;

public class AnonLimitPatcherV1Base implements SpecPatcher<TPodTemplateSpec.Builder> {
    //default value for: (Memory limit - anonymous memory limit)
    //This constant is "hardcoded" by intent, don't move it to application config.
    //Changing this parameter will force resources reallocation (and rebuild of all boxes),
    //  if user didn't specify anonymous memory limit
    public static final long DEFAULT_FILE_CACHE_RESERVED_MEMORY_SIZE = 128 * PodSpecUtils.MEGABYTE;

    public AnonLimitPatcherV1Base(AnonLimitPatcherContext context) {

    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        DataModel.TPodSpec.TResourceRequests.Builder resources =  podTemplateSpecBuilder.getSpecBuilder().getResourceRequestsBuilder();

        if (resources.hasAnonymousMemoryLimit() && resources.getAnonymousMemoryLimit() > 0) {
            return;
        }

        if (!resources.hasMemoryLimit()) {
            throw new RuntimeException("Memory limit should be set before patching anonymous memory limit");
        }

        patchMissedAnonMemoryLimit(resources);
    }

    protected void patchMissedAnonMemoryLimit(DataModel.TPodSpec.TResourceRequests.Builder resources) {
        long podMemoryLimit = resources.getMemoryLimit();
        resources.setAnonymousMemoryLimit(podMemoryLimit - Math.min(DEFAULT_FILE_CACHE_RESERVED_MEMORY_SIZE, podMemoryLimit / 10));
    }
}
