package ru.yandex.infra.stage.podspecs.patcher.defaults;

import java.util.List;
import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;

public class DefaultsPatcherV1Context {
    private final ResourceSupplier defaultPodAgentBinarySupplier;
    private final ResourceSupplier defaultPodAgentLayerSupplier;
    private final Optional<String> podAgentAllocationId;
    private final boolean patchBoxSpecificType;
    private final long releaseGetterTimeoutSeconds;
    private final boolean placeBinaryRevisionToPodAgentMeta;
    private final Optional<List<String>> allSidecarDiskAllocationIds;

    public DefaultsPatcherV1Context(
            ResourceSupplier defaultPodAgentBinarySupplier,
            ResourceSupplier defaultPodAgentLayerSupplier,
            Optional<String> podAgentAllocationId,
            boolean patchBoxSpecificType,
            long releaseGetterTimeoutSeconds,
            boolean placeBinaryRevisionToPodAgentMeta,
            Optional<List<String>> allSidecarDiskAllocationIds) {
        this.defaultPodAgentBinarySupplier = defaultPodAgentBinarySupplier;
        this.defaultPodAgentLayerSupplier = defaultPodAgentLayerSupplier;
        this.podAgentAllocationId = podAgentAllocationId;
        this.patchBoxSpecificType = patchBoxSpecificType;
        this.releaseGetterTimeoutSeconds = releaseGetterTimeoutSeconds;
        this.placeBinaryRevisionToPodAgentMeta = placeBinaryRevisionToPodAgentMeta;
        this.allSidecarDiskAllocationIds = allSidecarDiskAllocationIds;
    }

    public long getReleaseGetterTimeoutSeconds() {
        return releaseGetterTimeoutSeconds;
    }

    public ResourceSupplier getDefaultPodAgentBinarySupplier() {
        return defaultPodAgentBinarySupplier;
    }

    public ResourceSupplier getDefaultPodAgentLayerSupplier() {
        return defaultPodAgentLayerSupplier;
    }

    public Optional<String> getPodAgentAllocationId() {
        return podAgentAllocationId;
    }

    public boolean isPatchBoxSpecificType() {
        return patchBoxSpecificType;
    }

    public Optional<List<String>> getAllSidecarDiskAllocationIds() { return allSidecarDiskAllocationIds; }

    public boolean placeBinaryRevisionToPodAgentMeta() { return placeBinaryRevisionToPodAgentMeta; }

    @VisibleForTesting
    DefaultsPatcherV1Context withPatchBoxSpecificType(boolean patchBoxSpecificType) {
        return toBuilder().withPatchBoxSpecificType(patchBoxSpecificType).build();
    }

    @VisibleForTesting
    DefaultsPatcherV1Context withPlaceBinaryRevisionToPodAgentMeta(boolean placeBinaryRevisionToPodAgentMeta) {
        return toBuilder().withPlaceBinaryRevisionToPodAgentMeta(placeBinaryRevisionToPodAgentMeta).build();
    }

    @VisibleForTesting
    Builder toBuilder() {
        return new Builder(this);
    }

    @VisibleForTesting
    static class Builder {
        private final ResourceSupplier defaultPodAgentBinarySupplier;
        private final ResourceSupplier defaultPodAgentLayerSupplier;
        private Optional<String> podAgentAllocationId;
        private boolean patchBoxSpecificType;
        private final long releaseGetterTimeoutSeconds;
        private boolean placeBinaryRevisionToPodAgentMeta;
        private Optional<List<String>> allSidecarDiskAllocationIds;

        Builder(DefaultsPatcherV1Context context) {
            this.defaultPodAgentBinarySupplier = context.defaultPodAgentBinarySupplier;
            this.defaultPodAgentLayerSupplier = context.defaultPodAgentLayerSupplier;
            this.podAgentAllocationId = context.podAgentAllocationId;
            this.patchBoxSpecificType = context.patchBoxSpecificType;
            this.releaseGetterTimeoutSeconds = context.releaseGetterTimeoutSeconds;
            this.placeBinaryRevisionToPodAgentMeta = context.placeBinaryRevisionToPodAgentMeta;
            this.allSidecarDiskAllocationIds = context.allSidecarDiskAllocationIds;
        }

        @VisibleForTesting
        DefaultsPatcherV1Context build() {
            return new DefaultsPatcherV1Context(
                    defaultPodAgentBinarySupplier,
                    defaultPodAgentLayerSupplier,
                    podAgentAllocationId,
                    patchBoxSpecificType,
                    releaseGetterTimeoutSeconds,
                    placeBinaryRevisionToPodAgentMeta,
                    allSidecarDiskAllocationIds
            );
        }

        @VisibleForTesting
        Builder withAllSidecarDiskAllocationIds(Optional<List<String>> allSidecarDiskAllocationIds) {
            this.allSidecarDiskAllocationIds = allSidecarDiskAllocationIds;
            return this;
        }

        @VisibleForTesting
        Builder withPodAgentAllocationId(Optional<String> podAgentAllocationId) {
            this.podAgentAllocationId = podAgentAllocationId;
            return this;
        }

        Builder withPatchBoxSpecificType(boolean patchBoxSpecificType) {
            this.patchBoxSpecificType = patchBoxSpecificType;
            return this;
        }

        Builder withPlaceBinaryRevisionToPodAgentMeta(boolean placeBinaryRevisionToPodAgentMeta) {
            this.placeBinaryRevisionToPodAgentMeta = placeBinaryRevisionToPodAgentMeta;
            return this;
        }
    }
}
