package ru.yandex.infra.stage.podspecs.patcher.defaults;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TPodTemplateSpec;

public class DefaultsPatcherV2 extends DefaultsPatcherV1Base {

    public DefaultsPatcherV2(DefaultsPatcherV1Context context) {
        super(context);
    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        patchHostNameKind(podTemplateSpecBuilder.getSpecBuilder());
        patchPodSpec(podTemplateSpecBuilder, context, getPodAgentBinarySupplier(context), getPodAgentLayerSupplier(context));
    }

    @Override
    protected void patchNodeFilterWithSox(DataModel.TPodSpec.Builder podSpec, boolean isSoxService) {
        patchNodeFilterWithSoxFromV1ToV3(podSpec, isSoxService);
    }
}
