package ru.yandex.infra.stage.podspecs.patcher.dynamic_resource;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;

public class DynamicResourcePatcherV1Context {

    private final ResourceSupplier druDefaultLayerSupplier;
    private final ResourceSupplier druLayerSupplier;
    private final long releaseGetterTimeoutSeconds;

    public DynamicResourcePatcherV1Context(ResourceSupplier druDefaultLayerSupplier, ResourceSupplier druLayerSupplier,
                                           long releaseGetterTimeoutSeconds) {
        this.druDefaultLayerSupplier = druDefaultLayerSupplier;
        this.druLayerSupplier = druLayerSupplier;
        this.releaseGetterTimeoutSeconds = releaseGetterTimeoutSeconds;
    }

    public ResourceSupplier getDruDefaultLayerSupplier() {
        return druDefaultLayerSupplier;
    }

    public ResourceSupplier getDruLayerSupplier() {
        return druLayerSupplier;
    }

    public long getReleaseGetterTimeoutSeconds() {
        return releaseGetterTimeoutSeconds;
    }
}
