package ru.yandex.infra.stage.podspecs.patcher.dynamic_resource;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.dto.AllComputeResources;

import static ru.yandex.infra.stage.podspecs.PodSpecUtils.MEGABYTE;

public class DynamicResourcePatcherV3 extends DynamicResourcePatcherV1Base {

    @VisibleForTesting
    static final AllComputeResources DRU_ADDITIONAL_RESOURCES =
            new AllComputeResources(100, 128 * MEGABYTE, 112 * MEGABYTE, 0, 0);

    public DynamicResourcePatcherV3(DynamicResourcePatcherV1Context context) {
        super(context);
    }

    @Override
    protected AllComputeResources getAdditionalBoxResources() {
        return DRU_ADDITIONAL_RESOURCES;
    }
}
