package ru.yandex.infra.stage.podspecs.patcher.dynamic_resource;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.dto.AllComputeResources;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.pods.TBox;

import static ru.yandex.infra.stage.podspecs.PodSpecUtils.MEGABYTE;
import static ru.yandex.infra.stage.podspecs.PodSpecUtils.addCpuMemResources;
import static ru.yandex.infra.stage.podspecs.PodSpecUtils.addResources;

public class DynamicResourcePatcherV4 extends DynamicResourcePatcherV1Base {

    @VisibleForTesting
    static final AllComputeResources DRU_ADDITIONAL_RESOURCES =
            new AllComputeResources(100, 128 * MEGABYTE, 112 * MEGABYTE, 0, 0);

    public DynamicResourcePatcherV4(DynamicResourcePatcherV1Context context) {
        super(context);
    }

    @Override
    protected AllComputeResources getAdditionalBoxResources() {
        return DRU_ADDITIONAL_RESOURCES;
    }

    @Override
    protected void patchBoxAndPodResources(DataModel.TPodSpec.Builder podSpecBuilder, TBox.Builder boxBuilder) {
        var resources = getAdditionalBoxResources();
        if (resources != null) {
            addCpuMemResources(podSpecBuilder, resources);
            addResources(boxBuilder, resources, false);
        }
    }
}
