package ru.yandex.infra.stage.podspecs.patcher.dynamic_resource;

import java.util.Map;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.deployunit.SandboxResourcesResolver;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DynamicResource;

public class DynamicResourceResolvedResourcesPatcher implements SpecPatcher<DynamicResource.TDynamicResourceSpec.Builder> {
    SandboxResourcesResolver sandboxResolver;

    public DynamicResourceResolvedResourcesPatcher(SandboxResourcesResolver sandboxResolver) {
        this.sandboxResolver = sandboxResolver;
    }

    @Override
    public void patch(DynamicResource.TDynamicResourceSpec.Builder dynamicResourceSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        Map<String, String> resolvedResources = sandboxResolver.get(context.getFullDeployUnitId());

        if (resolvedResources == null || resolvedResources.isEmpty()) {
            return;
        }

        dynamicResourceSpecBuilder.getDeployGroupsBuilderList().forEach(b -> {
            for (int i = 0; i < b.getUrlsCount(); i++) {
                String url = b.getUrls(i);
                b.setUrls(i, resolvedResources.getOrDefault(url, url));
            }
        });
    }
}

