package ru.yandex.infra.stage.podspecs.patcher.endpoint_set_liveness;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;


abstract class EndpointSetLivenessPatcherV1Base implements SpecPatcher<DataModel.TEndpointSetSpec.Builder> {

    private final static double ENDPOINT_SET_DEFAULT_LIVENESS_LIMIT_RATIO = 1.0;;


    @Override
    public void patch(DataModel.TEndpointSetSpec.Builder endpointSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {

        if (endpointSpecBuilder.getLivenessLimitRatio() == 0.0) {
            endpointSpecBuilder.setLivenessLimitRatio(getDefaultLivenessRatio());
        }
    }

    protected double getDefaultLivenessRatio() {
        return ENDPOINT_SET_DEFAULT_LIVENESS_LIMIT_RATIO;
    }

}
