package ru.yandex.infra.stage.podspecs.patcher.endpoint_set_port;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;


abstract class EndpointSetPortPatcherV1Base implements SpecPatcher<DataModel.TEndpointSetSpec.Builder> {

    private final static int ENDPOINT_SET_DEFAULT_PORT = 80;


    @Override
    public void patch(DataModel.TEndpointSetSpec.Builder endpointSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        String filter = String.format("[/meta/pod_set_id] = \"%s\"", context.getFullDeployUnitId());
        if (endpointSpecBuilder.getPort() == 0) {
            endpointSpecBuilder.setPort(ENDPOINT_SET_DEFAULT_PORT);
        }
        endpointSpecBuilder.setPodFilter(filter);
    }

}
