package ru.yandex.infra.stage.podspecs.patcher.juggler;

import java.util.Map;

import ru.yandex.infra.stage.dto.AllComputeResources;
import ru.yandex.infra.stage.dto.BoxJugglerConfig;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.pods.TUtilityContainer;

import static ru.yandex.infra.stage.podspecs.PodSpecUtils.patchRootDiskVolumeRequests;

public class JugglerPatcherV1 extends JugglerPatcherV1Base {

    private static final String INIT_SCRIPT = createJugglerInitScript("juggler_init_template.sh");

    public JugglerPatcherV1(JugglerPatcherV1Context context) {
        super(context);
    }

    protected TUtilityContainer createStartContainer(BoxJugglerConfig config) {
        return TUtilityContainer.newBuilder()
                .setCommandLine(String.format(TEMPLATE_START_COMMAND, config.getPortOrDefault()))
                .build();
    }

    @Override
    protected AllComputeResources getAdditionalBoxResources() {
        return JugglerPatcherV1Base.JUGGLER_RESOURCE_PER_BOX_V1;
    }

    @Override
    protected String archiveCheckMountPoint(String resourceId) {
        return String.format("%s/%s", JUGGLER_DIR_ROOT, JUGGLER_DIR_TAR_CHECKS);
    }

    @Override
    protected String getInitScript() {
        return INIT_SCRIPT;
    }

    @Override
    protected void patchDiskQuota(DataModel.TPodSpec.Builder spec, long allAdditionalDiskCapacity, Map<String, Map<String, BoxJugglerConfig>> diskIdToBoxJugglerConfigs) {
        patchRootDiskVolumeRequests(spec, allAdditionalDiskCapacity);
    }

    @Override
    protected boolean patchBoxesWithoutConstraint() {
        return true;
    }
}
