package ru.yandex.infra.stage.podspecs.patcher.juggler;

import java.util.List;
import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;

public class JugglerPatcherV1Context {

    private final ResourceSupplier jugglerBinaryDefaultSupplier;
    private final Optional<List<String>> allSidecarDiskAllocationIds;

    public JugglerPatcherV1Context(ResourceSupplier jugglerBinaryDefaultSupplier, Optional<List<String>> allSidecarDiskAllocationIds) {
        this.jugglerBinaryDefaultSupplier = jugglerBinaryDefaultSupplier;
        this.allSidecarDiskAllocationIds = allSidecarDiskAllocationIds;
    }

    public ResourceSupplier getJugglerBinaryDefaultSupplier() {
        return jugglerBinaryDefaultSupplier;
    }


    public Optional<List<String>> getAllSidecarDiskAllocationIds() { return allSidecarDiskAllocationIds; }

    @VisibleForTesting
    JugglerPatcherV1Context withAllSidecarDiskAllocationIds(List<String> allSidecarDiskAllocationIds) {
        return toBuilder().withAllSidecarDiskAllocationIds(allSidecarDiskAllocationIds).build();
    }

    private Builder toBuilder() {
        return new Builder(this);
    }

    private static class Builder {
        private final ResourceSupplier jugglerBinaryDefaultSupplier;
        private Optional<List<String>> allSidecarDiskAllocationIds;

        Builder(JugglerPatcherV1Context context) {
            this.jugglerBinaryDefaultSupplier = context.jugglerBinaryDefaultSupplier;
            this.allSidecarDiskAllocationIds = context.allSidecarDiskAllocationIds;
        }

        JugglerPatcherV1Context build() {
            return new JugglerPatcherV1Context(
                    jugglerBinaryDefaultSupplier,
                    allSidecarDiskAllocationIds
            );
        }

        Builder withAllSidecarDiskAllocationIds(List<String> allSidecarDiskAllocationIds) {
            this.allSidecarDiskAllocationIds = Optional.ofNullable(allSidecarDiskAllocationIds);
            return this;
        }
    }
}
