package ru.yandex.infra.stage.podspecs.patcher.logbroker;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;

import ru.yandex.infra.stage.config.AllComputeResourcesConfigParser;
import ru.yandex.infra.stage.config.WhiteListConfigParser;

final class LogbrokerBoxResourcesConfigParser {

    private LogbrokerBoxResourcesConfigParser() {

    }

    @VisibleForTesting
    static final String RESOURCES_CONFIG_PATH = "resources";

    @VisibleForTesting
    static LogbrokerBoxResourcesConfig parseResourcesConfigFrom(Config logbrokerBoxConfig) {
        var logbrokerBoxResourcesConfig = logbrokerBoxConfig.getConfig(RESOURCES_CONFIG_PATH);

        return parseConfig(logbrokerBoxResourcesConfig);
    }

    @VisibleForTesting
    static LogbrokerBoxResourcesConfig parseConfig(Config config) {
        var whiteListResources = WhiteListConfigParser.parseWhiteListFrom(
                config,
                AllComputeResourcesConfigParser::parseConfig
        );

        return new LogbrokerBoxResourcesConfig(
                whiteListResources
        );
    }
}
