package ru.yandex.infra.stage.podspecs.patcher.logbroker;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

import ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config.UnifiedAgentConfigFactory;

public final class LogbrokerPatcherConfig {

    private final UnifiedAgentConfigFactory unifiedAgentConfigFactory;
    private final LogbrokerBoxResourcesConfig boxResourcesConfig;

    LogbrokerPatcherConfig(UnifiedAgentConfigFactory unifiedAgentConfigFactory,
                           LogbrokerBoxResourcesConfig boxResourcesConfig) {
        this.unifiedAgentConfigFactory = unifiedAgentConfigFactory;
        this.boxResourcesConfig = boxResourcesConfig;
    }

    public UnifiedAgentConfigFactory getUnifiedAgentConfigFactory() {
        return unifiedAgentConfigFactory;
    }

    public LogbrokerBoxResourcesConfig getBoxResourcesConfig() {
        return boxResourcesConfig;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogbrokerPatcherConfig that = (LogbrokerPatcherConfig) o;
        return Objects.equal(unifiedAgentConfigFactory, that.unifiedAgentConfigFactory)
                && Objects.equal(boxResourcesConfig, that.boxResourcesConfig);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                unifiedAgentConfigFactory,
                boxResourcesConfig
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("unifiedAgentConfigFactory", unifiedAgentConfigFactory)
                .add("boxResourcesConfig", boxResourcesConfig)
                .toString();
    }
}
