package ru.yandex.infra.stage.podspecs.patcher.logbroker;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;

import ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config.UnifiedAgentConfigFactoryParser;

public final class LogbrokerPatcherConfigParser {

    private LogbrokerPatcherConfigParser() {
    }

    @VisibleForTesting
    public static final String UNIFIED_AGENT_CONFIG_FACTORY_CONFIG_PATH = "unified_agent_config_generation";

    @VisibleForTesting
    static final String BOX_CONFIG_PATH = "box";

    public static LogbrokerPatcherConfig parseConfig(Config config) {
        var unifiedAgentConfigFactory = UnifiedAgentConfigFactoryParser.parseConfig(
                config.getConfig(UNIFIED_AGENT_CONFIG_FACTORY_CONFIG_PATH)
        );

        var boxResourcesConfig = LogbrokerBoxResourcesConfigParser.parseResourcesConfigFrom(
                config.getConfig(BOX_CONFIG_PATH)
        );

        return new LogbrokerPatcherConfig(unifiedAgentConfigFactory, boxResourcesConfig);
    }
}
