package ru.yandex.infra.stage.podspecs.patcher.logbroker;

import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.infra.stage.dto.LogbrokerConfig;
import ru.yandex.infra.stage.dto.LogbrokerTopicDescription;
import ru.yandex.yp.client.pods.ETransmitSystemLogs;
import ru.yandex.yp.client.pods.TPodAgentSpecOrBuilder;
import ru.yandex.yp.client.pods.TWorkloadOrBuilder;

public final class LogbrokerPatcherUtils {

    private LogbrokerPatcherUtils() {
    }

    public static final String LOGBROKER_BOX_ID = "logbroker-tools-box";
    public static final String LOGBROKER_BOX_ID_UNDERSCORED = "logbroker_tools_box";
    public static final String LOGBROKER_BASE_LAYER_ID = "logbroker_base_layer";
    public static final String LOGBROKER_TOOLS_LAYER_ID = "logbroker_tools_layer";
    public static final String LOGBROKER_AGENT_WORKLOAD_ID = "logbroker_push_agent_workload";
    public static final String LOGBROKER_MONITOR_WORKLOAD_ID = "logbroker_monitor_workload";
    public static final String LOGBROKER_DEFAULT_STATIC_SECRET = "STATIC_SECRET";
    public static final String LOGBROKER_AGENT_LOGS_VOLUME_ID = "logbroker_push_agent_logs_volume_id";
    public static final String LOGBROKER_AGENT_PORTO_LOGS_VOLUME_ID = "logbroker_push_agent_porto_logs_volume_id";
    public static final String LOGBROKER_AGENT_STATE_VOLUME_ID = "logbroker_agent_state_volume_id";
    public static final String LOGBROKER_TEST_STAGE_PREFIX = "logbroker_test_";
    public static final long LOGBROKER_THREAD_LIMIT = 150L;

    public static final String DEPLOY_LOGNAME_ENV_NAME = "DEPLOY_LOGS_DEFAULT_NAME";
    public static final String DEPLOY_LOGS_ENDPOINT_ENV_NAME = "DEPLOY_LOGS_ENDPOINT";
    public static final String DEPLOY_LOGS_SECRET_ENV_NAME = "DEPLOY_LOGS_SECRET";

    public static final String ERROR_BOOSTER_SYSLOG_HOST = "ERROR_BOOSTER_SYSLOG_HOST";
    public static final String ERROR_BOOSTER_SYSLOG_PORT = "ERROR_BOOSTER_SYSLOG_PORT";
    public static final String ERROR_BOOSTER_HTTP_HOST = "ERROR_BOOSTER_HTTP_HOST";
    public static final String ERROR_BOOSTER_HTTP_PORT = "ERROR_BOOSTER_HTTP_PORT";

    public static final String ERROR_BOOSTER_SENTRY_DSN = "ERROR_BOOSTER_SENTRY_DSN";
    public static final String ERROR_BOOSTER_SENTRY_DSN_HARDCODE = "http://146c07ef2479cedcd54c7c2af5cf3a80@127.0.0.1:12520/111"; // DEPLOY-5447

    public static final String LOCALHOST = "127.0.0.1";


    public static final int DEFAULT_UNIFIED_AGENT_POLICY_MAX_TRIES = 3;
    public static final long DEFAULT_UNIFIED_AGENT_POLICY_RESTART_PERIOD_MS = 10000;

    public static final String MINIMAL_UNIFIED_AGENT_DESTROY_POLICY_RESTART_PERIOD_MS_CONFIG_KEY =
            "minimal_restart_period_ms";

    public static final String MAXIMAL_UNIFIED_AGENT_DESTROY_POLICY_TOTAL_RESTART_PERIOD_MS_CONFIG_KEY =
            "maximal_total_restart_period_ms";

    public static final LogbrokerTopicDescription LOGBROKER_AGENT_COMMUNAL_TOPIC_DESCRIPTION = new LogbrokerTopicDescription(
            2010882, "deploy/logs"
    );

    public static final String LOGBROKER_AGENT_TVM_SECRET_ENV_NAME = "TVM_SECRET";
    public static final int LOGBROKER_AGENT_MONITORING_PORT = 12501;
    public static final String LOGBROKER_AGENT_OUT_CHANNEL_ENDPOINT = "logbroker.yandex.net";
    public static final List<Integer> LOGBROKER_AGENT_SOLOMON_TVM_CLIENT_IDS = ImmutableList.of(2012024, 2012026, 2012028);

    public static final long MAX_LOGBROKER_BOX_VCPU = 32000;

    public static boolean useLogbrokerTools(TPodAgentSpecOrBuilder agentSpec, LogbrokerConfig logbrokerConfig) {
        return logbrokerConfig.bringupSidecarMandatory() ||
               agentSpec.getWorkloadsOrBuilderList().stream().anyMatch(TWorkloadOrBuilder::getTransmitLogs) ||
               agentSpec.getTransmitSystemLogsPolicy().getTransmitSystemLogs() == ETransmitSystemLogs.ETransmitSystemLogsPolicy_ENABLED;
    }
}
