package ru.yandex.infra.stage.podspecs.patcher.logbroker;

import ru.yandex.infra.stage.dto.AllComputeResources;

public class LogbrokerPatcherV1 extends LogbrokerPatcherV1Base {

    public LogbrokerPatcherV1(LogbrokerPatcherV1Context context) {
        super(context);
    }

    @Override
    protected AllComputeResources getPatcherDefaultBoxResources() {
        return LOGBROKER_BOX_COMPUTING_RESOURCES_FOR_V1;
    }

    @Override
    protected String getPatcherThrottlingLimitsKey() {
        return LOGBROKER_PATCHER_THROTTLING_LIMITS_KEY_FROM_V1_TO_V2;
    }

    @Override
    protected String getLogbrokerBoxId() {
        return LogbrokerPatcherUtils.LOGBROKER_BOX_ID_UNDERSCORED;
    }

    @Override
    protected boolean errorBoosterEnvironmentsExport(){
        return false;
    }

    @Override
    protected boolean errorBoosterHttpInputEnvironmentsExport() {
        return false;
    }

    @Override
    protected boolean autoEnableSystemLogsWhenUserLogsEnabled() {
        return false;
    }

}

