package ru.yandex.infra.stage.podspecs.patcher.logbroker;

import java.util.List;
import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;
import ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config.UnifiedAgentConfigFactory;

public class LogbrokerPatcherV1Context {

    private final ResourceSupplier logbrokerAgentLayerSupplier;

    private final Optional<String> diskVolumeAllocationId;
    private final Optional<List<String>> allSidecarDiskAllocationIds;
    private final boolean patchBoxSpecificType;

    private final UnifiedAgentConfigFactory unifiedAgentConfigFactory;
    private final LogbrokerBoxResourcesConfig boxResourcesConfig;

    private final long releaseGetterTimeoutSeconds;

    public LogbrokerPatcherV1Context(ResourceSupplier logbrokerAgentLayerSupplier,
                                     Optional<String> diskVolumeAllocationId,
                                     Optional<List<String>> allSidecarDiskAllocationIds, boolean patchBoxSpecificType,
                                     UnifiedAgentConfigFactory unifiedAgentConfigFactory,
                                     LogbrokerBoxResourcesConfig boxResourcesConfig,
                                     long releaseGetterTimeoutSeconds) {
        this.logbrokerAgentLayerSupplier = logbrokerAgentLayerSupplier;
        this.diskVolumeAllocationId = diskVolumeAllocationId;
        this.allSidecarDiskAllocationIds = allSidecarDiskAllocationIds;
        this.patchBoxSpecificType = patchBoxSpecificType;
        this.unifiedAgentConfigFactory = unifiedAgentConfigFactory;
        this.boxResourcesConfig = boxResourcesConfig;
        this.releaseGetterTimeoutSeconds = releaseGetterTimeoutSeconds;
    }

    public ResourceSupplier getLogbrokerAgentLayerSupplier() {
        return logbrokerAgentLayerSupplier;
    }

    public Optional<String> getDiskVolumeAllocationId() {
        return diskVolumeAllocationId;
    }

    public Optional<List<String>> getAllSidecarDiskAllocationIds() {
        return allSidecarDiskAllocationIds;
    }

    public boolean isPatchBoxSpecificType() {
        return patchBoxSpecificType;
    }

    public UnifiedAgentConfigFactory getUnifiedAgentConfigFactory() {
        return unifiedAgentConfigFactory;
    }

    public LogbrokerBoxResourcesConfig getBoxResourcesConfig() {
        return boxResourcesConfig;
    }

    public long getReleaseGetterTimeoutSeconds() {
        return releaseGetterTimeoutSeconds;
    }

    @VisibleForTesting
    Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder {

        private ResourceSupplier logbrokerAgentLayerSupplier;

        private Optional<String> diskVolumeAllocationId;
        private Optional<List<String>> allSidecarDiskAllocationIds;
        private boolean patchBoxSpecificType;

        private UnifiedAgentConfigFactory unifiedAgentConfigFactory;
        private LogbrokerBoxResourcesConfig boxResourcesConfig;

        private final long releaseGetterTimeoutSeconds;

        Builder(LogbrokerPatcherV1Context context) {
            this.logbrokerAgentLayerSupplier = context.logbrokerAgentLayerSupplier;
            this.diskVolumeAllocationId = context.diskVolumeAllocationId;
            this.allSidecarDiskAllocationIds = context.allSidecarDiskAllocationIds;
            this.patchBoxSpecificType = context.patchBoxSpecificType;
            this.unifiedAgentConfigFactory = context.unifiedAgentConfigFactory;
            this.boxResourcesConfig = context.boxResourcesConfig;
            this.releaseGetterTimeoutSeconds = context.releaseGetterTimeoutSeconds;
        }

        Builder withDiskVolumeAllocationId(String diskVolumeAllocationId) {
            this.diskVolumeAllocationId = Optional.ofNullable(diskVolumeAllocationId);
            return this;
        }

        Builder withAllSidecarDiskAllocationIds(List<String> allSidecarDiskAllocationIds) {
            this.allSidecarDiskAllocationIds = Optional.ofNullable(allSidecarDiskAllocationIds);
            return this;
        }

        Builder withPatchBoxSpecificType(boolean patchBoxSpecificType) {
            this.patchBoxSpecificType = patchBoxSpecificType;
            return this;
        }

        Builder withLogbrokerAgentLayerSupplier(ResourceSupplier logbrokerAgentLayerSupplier) {
            this.logbrokerAgentLayerSupplier = logbrokerAgentLayerSupplier;
            return this;
        }

        Builder withUnifiedAgentConfigFactory(UnifiedAgentConfigFactory unifiedAgentConfigFactory) {
            this.unifiedAgentConfigFactory = unifiedAgentConfigFactory;
            return this;
        }

        Builder withBoxResourcesConfig(LogbrokerBoxResourcesConfig boxResourcesConfig) {
            this.boxResourcesConfig = boxResourcesConfig;
            return this;
        }

        LogbrokerPatcherV1Context build() {
            return new LogbrokerPatcherV1Context(
                    logbrokerAgentLayerSupplier,
                    diskVolumeAllocationId,
                    allSidecarDiskAllocationIds,
                    patchBoxSpecificType,
                    unifiedAgentConfigFactory,
                    boxResourcesConfig,
                    releaseGetterTimeoutSeconds
            );
        }
    }
}
