package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import java.util.Collection;
import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.podspecs.SandboxResourceMeta;
import ru.yandex.yp.client.pods.TLayer;

import static ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils.LOGBROKER_TOOLS_LAYER_ID;

final class BuildTaskIdCalculatorImpl implements BuildTaskIdCalculator {

    static final BuildTaskIdCalculatorImpl INSTANCE = new BuildTaskIdCalculatorImpl();

    private BuildTaskIdCalculatorImpl(){

    }

    @VisibleForTesting
    static final long FIXED_TASK_ID = 0;

    @Override
    public long calculate(Collection<TLayer> podAgentPayloadLayers, Optional<SandboxResourceMeta> unifiedAgentSandboxMeta) {
        if (podAgentPayloadLayers.stream()
                .anyMatch(r -> r.getId().equals(LOGBROKER_TOOLS_LAYER_ID))) {
            return FIXED_TASK_ID;
        }

        return unifiedAgentSandboxMeta.map(SandboxResourceMeta::getTaskId).orElse(FIXED_TASK_ID);
    }
}
